function cycle = createERoadFromVecto(cycle, opt)
arguments
    cycle
    opt
end
%createERoadFromVecto
% vectoMissionFile: VECTO .vdri file
% opt.L1: length of first non electrified segment, km
% opt.Le: length of electrified segment (which follows L1), km
% opt.eRoadSpd: target speed on the eRoad, km/h


%% Create e-road
% Retrieve distance breakpoints
distBrk = cycle.speed_kmh.GridVectors{1}; % m

% Convert in metre
opt.L1 = opt.L1*1e3; % m
opt.Le = opt.Le*1e3; % m
% Total distance
L = distBrk(end);
% second unelectrified distance 
L2 = L - opt.L1 - opt.Le;
% eroad flag as function of the distance
eRoad = false(size(distBrk));
eRoad( distBrk >= opt.L1 & distBrk < (opt.L1+opt.Le) ) = true;

% Set the vehicle speed in the eroad section
cycle.speed_kmh.Values( eRoad == 1 ) = opt.eRoadSpd;
cycle.eRoad = griddedInterpolant(distBrk, single(eRoad), "nearest");

end